#include "DIcono.h"

namespace DWL {

    void DIcono::CargarIconoCSLID(const int CSIDL, const DEnum_DIcono_Tam nTam) {
        DWORD_PTR hr;
        LPITEMIDLIST pidl = 0;
        SHFILEINFO sfi = { 0 };
        hr = SHGetSpecialFolderLocation(0, CSIDL, &pidl);
        hr = SHGetFileInfo((LPCTSTR)pidl, -1, &sfi, sizeof(sfi), SHGFI_PIDL | SHGFI_ICONLOCATION);

        hr = SHGetFileInfo((LPCTSTR)pidl, -1, &sfi, sizeof(sfi), SHGFI_PIDL | SHGFI_ICON | static_cast<UINT>(nTam));
        _Icono = sfi.hIcon;
    };

    void DIcono::CargarIconoRecursos(const int cID, const int nAncho, const int nAlto) {
        _Icono = static_cast<HICON>(LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(cID), IMAGE_ICON, nAncho, nAlto, LR_DEFAULTCOLOR)); 
    };

    void DIcono::CargarIconoExplorador(const TCHAR *nPath, const DEnum_DIcono_Tam nTam) {
        DWORD_PTR hr;
        SHFILEINFO sfi = { 0 };

        hr = SHGetFileInfo(nPath, 0, &sfi, sizeof(sfi), SHGFI_ICONLOCATION);

        hr = SHGetFileInfo(nPath, 0, &sfi, sizeof(sfi), SHGFI_ICON | static_cast<UINT>(nTam));
        if (SUCCEEDED(hr)) {
            _Icono = sfi.hIcon;
        }
    };

    void DIcono::CargarIcono(const TCHAR *nPath, const int nAncho, const int nAlto) {
        _Icono = static_cast<HICON>(LoadImage(GetModuleHandle(NULL), nPath, IMAGE_ICON, nAncho, nAlto, LR_DEFAULTCOLOR)); 
    };
};